/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.dvirlog;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.extern.slf4j.Slf4j;

/**
 * The type of {@link DVIRLog}.
 */
@Slf4j
@SuppressWarnings("AbbreviationAsWordInName")
public enum DVIRLogType implements HasName {

  /**
   * Unknown log type.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown", 0),

  /**
   * Pre-trip log type.
   */
  PRE_TRIP("PreTrip", 1),

  /**
   * Post-trip log type.
   */
  POST_TRIP("PostTrip", 2),

  /**
   * In-trip log type.
   */
  IN_TRIP("InTrip", 3);

  private final String name;
  private final int code;

  DVIRLogType(String name, int code) {
    this.name = name;
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  @JsonValue
  public String getName() {
    return name;
  }

  public static DVIRLogType findOrDefault(String name) {
    if (Util.isEmpty(name)) {
      log.warn("Empty value is not recognized for {} enum; returning default {}",
          DVIRLogType.class.getSimpleName(), DVIRLogType.UNKNOWN);
      return UNKNOWN;
    }

    for (DVIRLogType dvirLog : values()) {
      if (dvirLog.getName().equalsIgnoreCase(name.trim())) {
        return dvirLog;
      }
    }

    log.warn("{} is not recognized for {} enum; returning default {}",
        name, DVIRLogType.class.getSimpleName(), DVIRLogType.UNKNOWN);
    return UNKNOWN;
  }
}
