/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.dvirlog;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public enum RepairStatusType implements HasName {

  /**
   * Fallback when enumeration value is unknown.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown", -1),

  /**
   * Defect has not been repaired yet.
   */
  NOT_REPAIRED("NotRepaired", 0),

  /**
   * Defect has been Repaired.
   */
  REPAIRED("Repaired", 1),

  /**
   * Defect has identified as Not Necessary to repair.
   */
  NOT_NECESSARY("NotNecessary", 2);

  private final String name;
  private final int code;

  RepairStatusType(String name, int code) {
    this.name = name;
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  @JsonValue
  public String getName() {
    return name;
  }

  public static RepairStatusType findOrDefault(String name) {
    if (Util.isEmpty(name)) {
      log.warn("Empty value is not recognized for {} enum; returning default {}",
          RepairStatusType.class.getSimpleName(), RepairStatusType.UNKNOWN);
      return UNKNOWN;
    }

    for (RepairStatusType repairStatusType : values()) {
      if (repairStatusType.getName().equalsIgnoreCase(name.trim())) {
        return repairStatusType;
      }
    }

    log.warn("{} is not recognized for {} enum; returning default {}",
        name, RepairStatusType.class.getSimpleName(), RepairStatusType.UNKNOWN);
    return UNKNOWN;
  }
}
