/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.enginetype;

import static com.geotab.model.entity.enginetype.EngineTypeGeneric.ENGINE_TYPE_GENERIC_ID;
import static com.geotab.model.entity.enginetype.EngineTypeNone.ENGINE_TYPE_NONE_ID;

import com.geotab.model.entity.NameEntity;
import com.geotab.util.Util;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

@Data
@NoArgsConstructor
@SuperBuilder
public class EngineType extends NameEntity {

  public static EngineType fromSystem(String id) {
    if (Util.isEmpty(id)) return null;
    if (ENGINE_TYPE_GENERIC_ID.equalsIgnoreCase(id.trim())) return EngineTypeGeneric.getInstance();
    if (ENGINE_TYPE_NONE_ID.equalsIgnoreCase(id.trim())) return EngineTypeNone.getInstance();
    return null;
  }
}
