package com.geotab.model.entity.enginetype;

import com.geotab.model.Id;
import lombok.Data;

/**
 * Represents the default {@link EngineType}.
 */
@Data
public final class EngineTypeGeneric extends EngineTypeSystem {

  private static class InstanceHolder {

    private static final EngineTypeGeneric INSTANCE = new EngineTypeGeneric();
  }

  public static final String ENGINE_TYPE_GENERIC_ID = "EngineTypeGenericId";

  private EngineTypeGeneric() {
    setId(new Id(ENGINE_TYPE_GENERIC_ID));
    setName("**Generic Engine Type");
  }

  public static EngineTypeGeneric getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
