/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.enginetype;

import com.geotab.model.Id;
import lombok.Data;

/**
 * Represents an empty (null) {@link EngineType }, used for devices that are not engine-assigned.
 */
@Data
public final class EngineTypeNone extends EngineTypeSystem {

  private static class InstanceHolder {

    private static final EngineTypeNone INSTANCE = new EngineTypeNone();
  }

  public static final String ENGINE_TYPE_NONE_ID = "EngineTypeNoneId";

  private EngineTypeNone() {
    setId(new Id(ENGINE_TYPE_NONE_ID));
    setName("**Unassigned Engine Type");
  }

  public static EngineTypeNone getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
