/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.failuremode;

import static com.geotab.model.entity.failuremode.NoFailureMode.NO_FAILURE_MODE_ID;

import com.geotab.model.entity.NameEntity;
import com.geotab.model.entity.source.Source;
import com.geotab.util.Util;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * The Failure Mode Identifier (FMI) used to describe engine fault codes. This is represented by the string
 * "NoFailureModeId" when there is no applicable FMI.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class FailureMode extends NameEntity {

  /**
   * The specific FMI code number.
   */
  private Double code;

  /**
   * The {@link Source} type for the FMI.
   */
  private Source source;

  public static FailureMode fromSystem(String id) {
    if (Util.isEmpty(id)) return null;
    if (NO_FAILURE_MODE_ID.equalsIgnoreCase(id)) return NoFailureMode.getInstance();
    return null;
  }
}
