/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.failuremode;

import com.geotab.model.Id;
import com.geotab.model.serialization.SystemEntitySerializationAware;
import lombok.Data;

/**
 * A {@link FailureMode} for diagnostics with no real world failure mode.
 */
@Data
public final class NoFailureMode extends FailureMode implements SystemEntitySerializationAware {

  private static class InstanceHolder {

    private static final NoFailureMode INSTANCE = new NoFailureMode();
  }

  public static final String NO_FAILURE_MODE_ID = "NoFailureModeId";

  private NoFailureMode() {
    setId(new Id(NO_FAILURE_MODE_ID));
    setName("**No Failure Mode");
  }

  public static NoFailureMode getInstance() {
    return InstanceHolder.INSTANCE;
  }

  @Override
  public boolean isSystemEntity() {
    return true;
  }
}
