/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.faultdata;

import static com.geotab.model.serialization.filter.FaultDataFilterProvider.FAULT_DATA_FILTER;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.entity.Entity;
import com.geotab.model.entity.controller.Controller;
import com.geotab.model.entity.device.Device;
import com.geotab.model.entity.device.DtcClass;
import com.geotab.model.entity.device.DtcSeverity;
import com.geotab.model.entity.device.FaultState;
import com.geotab.model.entity.diagnostic.Diagnostic;
import com.geotab.model.entity.failuremode.FailureMode;
import com.geotab.model.entity.flashcode.FlashCode;
import com.geotab.model.entity.user.User;
import com.geotab.model.serialization.EntityAsIdSerializer;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * A record that represents a fault code record from the engine system of the specific {@link
 * com.geotab.model.entity.device.Device}.
 */
@Data
@NoArgsConstructor
@SuperBuilder
@JsonFilter(FAULT_DATA_FILTER)
public class FaultData extends Entity {

  /**
   * Whether the amber warning lamp state.
   */
  private Boolean amberWarningLamp;

  /**
   * The {@link Controller} code related to the fault code; if applicable.
   */
  @JsonSerialize(using = EntityAsIdSerializer.class)
  private Controller controller;

  /**
   * The number of times the fault occurred.
   */
  private Integer count;

  /**
   * The date and time at which the event occurred.
   */
  private LocalDateTime dateTime;

  /**
   * The {@link Device} that generated the fault.
   */
  private Device device;

  /**
   * The {@link Diagnostic} associated with the fault.
   */
  private Diagnostic diagnostic;

  /**
   * The date and time that the DismissUser dismissed the fault.
   */
  private LocalDateTime dismissDateTime;

  /**
   * The {@link User} that dismissed the fault.
   */
  @JsonSerialize(using = EntityAsIdSerializer.class)
  private User dismissUser;

  /**
   * The {@link FailureMode} of the fault; if applicable.
   */
  private FailureMode failureMode;

  /**
   * The {@link FaultLampState} of a J1939 vehicle.
   */
  private FaultLampState faultLampState;

  /**
   * The {@link FaultState} code from the engine system of the specific device.
   */
  private FaultState faultState;

  /**
   * The {@link FlashCode} associated with the fault.
   */
  private FlashCode flashCode;

  /**
   * The malfunction light state.
   */
  private Boolean malfunctionLamp;

  /**
   * Whether the protect warning lamp is on.
   */
  private Boolean protectWarningLamp;

  /**
   * Whether the red stop lamp is on.
   */
  private Boolean redStopLamp;

  /**
   * The {@link DtcSeverity} of the fault.
   */
  private DtcSeverity severity;

  /**
   * The {@link DtcClass} code of the fault.
   */
  private DtcClass classCode;

  /**
   * The source address for enhanced faults.
   */
  private Integer sourceAddress;

  /**
   * A collection of FaultStatus details.
   */
  private FaultStateProvider faultStates;
}
