/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.faultdata;

import static com.geotab.model.entity.faultdata.FaultStatusActive.FAULT_STATUS_ACTIVE_ID;
import static com.geotab.model.entity.faultdata.FaultStatusCleared.FAULT_STATUS_CLEARED_ID;
import static com.geotab.model.entity.faultdata.FaultStatusInactive.FAULT_STATUS_INACTIVE_ID;
import static com.geotab.model.entity.faultdata.FaultStatusPending.FAULT_STATUS_PENDING_ID;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.Id;
import com.geotab.model.entity.NameEntity;
import com.geotab.model.serialization.FaultStatusAsStringSerializer;
import com.geotab.util.Util;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Class to describe FaultState.
 */
@Data
@NoArgsConstructor
@JsonSerialize(using = FaultStatusAsStringSerializer.class)
public class FaultStatus extends NameEntity {

  public FaultStatus(String id) {
    setId(new Id(id));
    setName(id);
  }

  public static FaultStatus fromSystem(String id) {
    if (Util.isEmpty(id)) return null;
    if (FAULT_STATUS_PENDING_ID.equalsIgnoreCase(id)) return FaultStatusPending.getInstance();
    if (FAULT_STATUS_ACTIVE_ID.equalsIgnoreCase(id)) return FaultStatusActive.getInstance();
    if (FAULT_STATUS_INACTIVE_ID.equalsIgnoreCase(id)) return FaultStatusInactive.getInstance();
    if (FAULT_STATUS_CLEARED_ID.equalsIgnoreCase(id)) return FaultStatusCleared.getInstance();
    return null;
  }
}
