package com.geotab.model.entity.faultdata;

import com.geotab.model.Id;
import lombok.Data;

/**
 * The Pending Fault Status.
 */
@Data
public final class FaultStatusNone extends FaultStatus {

  private static class InstanceHolder {

    private static final FaultStatusNone INSTANCE = new FaultStatusNone();
  }

  public static final String FAULT_STATUS_NONE_ID = "FaultStatusNoneId";
  public static final String FAULT_STATUS_NONE_NAME = "None";

  public static FaultStatusNone getInstance() {
    return FaultStatusNone.InstanceHolder.INSTANCE;
  }

  private FaultStatusNone() {
    setId(new Id(FAULT_STATUS_NONE_ID));
    setName(FAULT_STATUS_NONE_NAME);
  }
}
