/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.file;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public enum MediaType implements HasName {

  /**
   * Unknown file type.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown", 0),

  /**
   * Video file type.
   */
  VIDEO("Video", 1),

  /**
   * Image file type.
   */
  IMAGE("Image", 2),

  /**
   * Application file type.
   */
  APPLICATION("Application", 3),

  BINARY_DATA("BinaryData", 4);

  private final String name;
  private final int code;

  MediaType(String name, int code) {
    this.name = name;
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  @JsonValue
  public String getName() {
    return name;
  }

  public static MediaType findOrDefault(String name) {
    if (Util.isEmpty(name)) {
      log.warn("Empty value is not recognized for {} enum; returning default {}",
          MediaType.class.getSimpleName(), MediaType.UNKNOWN);
      return UNKNOWN;
    }

    for (MediaType mediaType : values()) {
      if (mediaType.getName().equalsIgnoreCase(name.trim())) {
        return mediaType;
      }
    }

    log.warn("{} is not recognized for {} enum; returning default {}",
        name, MediaType.class.getSimpleName(), MediaType.UNKNOWN);
    return UNKNOWN;
  }
}
