/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.file;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public enum Status implements HasName {

  /**
   * The status is unknown.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown", 0),

  /**
   * The file is being processed.
   */
  PROCESSING("Processing", 1),

  /**
   * The file is ready.
   */
  READY("Ready", 2),

  /**
   * Media file has not been upload.
   */
  NO_FILE("NoFile", 3);

  private final String name;
  private final int code;

  Status(String name, int code) {
    this.name = name;
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  @JsonValue
  public String getName() {
    return name;
  }

  public static Status findOrDefault(String name) {
    if (Util.isEmpty(name)) {
      log.warn("Empty value is not recognized for {} enum; returning default {}",
          Status.class.getSimpleName(), Status.UNKNOWN);
      return UNKNOWN;
    }

    for (Status status : values()) {
      if (status.getName().equalsIgnoreCase(name.trim())) {
        return status;
      }
    }

    log.warn("{} is not recognized for {} enum; returning default {}",
        name, Status.class.getSimpleName(), Status.UNKNOWN);
    return UNKNOWN;
  }
}
