/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.fuel;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;

public enum FuelEconomyUnit implements HasName {

  /**
   * Fallback when enumeration value is unknown.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown"),

  /**
   * The liters per 100 km unit.
   */
  LITERS_PER_100_KM("LitersPer100Km"),

  /**
   * The km per liter unit.
   */
  KM_PER_LITER("KmPerLiter"),

  /**
   * The miles per gallon (US).
   */
  MPGUS("MPGUS"),

  /**
   * The miles per gallon (Imperial).
   */
  MPG_IMPERIAL("MPGImperial"),

  GALLON_PER_100_KM("GallonPer100Km"),

  KM_PER_GALLON("KmPerGallon");

  private final String name;

  FuelEconomyUnit(String name) {
    this.name = name;
  }

  @JsonValue
  public String getName() {
    return name;
  }
}
