/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.fuel;

import com.geotab.model.coordinate.Coordinate;
import com.geotab.model.entity.EntityWithVersion;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Log of fueling events.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "fuelEventBuilder")
public class FuelEvent extends EntityWithVersion {

  /**
   * The driver recorded odometer reading in km. Default [0].
   */
  private Double odometer;

  /**
   * The volume of fuel purchased in Liters. Default [0].
   */
  private Double volume;

  /**
   * The cost of the fuel transaction. Default [0].
   */
  private BigDecimal cost;

  /**
   * The three digit ISO 427 currency code ( <a href="http://www.xe.com/iso4217.php">http://www.xe.com/iso4217.php</a>
   * ). Default ["USD"].
   */
  private String currencyCode;

  /**
   * The {@link Coordinate} of the transaction retailer. Default [0,0].
   */
  private Coordinate location;

  /**
   * The UTC date and time of the transaction.
   */
  private LocalDateTime dateTime;

  /**
   * The {@link FuelTransactionProductType} of this transaction. Default [{@link FuelTransactionProductType#UNKNOWN}].
   */
  private FuelTransactionProductType productType;
}
