/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.fuel;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Fuel tax attributes.
 */
@Data
@NoArgsConstructor
public class FuelTaxAttributes {

  /**
   * A value indicating whether updates are available to this detail.
   */
  private Boolean updatesAvailable;

  /**
   * The road type.
   */
  private FuelTaxRoadType roadType;

  @Builder
  public FuelTaxAttributes(Boolean updatesAvailable,
      FuelTaxRoadType roadType) {
    this.updatesAvailable = updatesAvailable;
    this.roadType = roadType;
  }
}
