/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.fuel;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public enum FuelTaxRoadType implements HasName {

  /**
   * Unknown road type.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown", 0),

  /**
   * Offroad road type.
   */
  OFF_ROAD("OffRoad", 1),

  /**
   * Public road type.
   */
  PUBLIC("Public", 2),

  /**
   * Private road type.
   */
  PRIVATE("Private", 3),

  /**
   * Private road type.
   */
  TOLL("Toll", 4),

  /**
   * Rail road type.
   */
  RAIL("Rail", 5);

  private final String name;
  private final int code;

  FuelTaxRoadType(String name, int code) {
    this.name = name;
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  @JsonValue
  public String getName() {
    return name;
  }

  public static FuelTaxRoadType findOrDefault(String name) {
    if (Util.isEmpty(name)) {
      log.warn("Empty value is not recognized for {} enum; returning default {}",
          FuelTaxRoadType.class.getSimpleName(), FuelTaxRoadType.UNKNOWN);
      return UNKNOWN;
    }

    for (FuelTaxRoadType fuelTaxRoadType : values()) {
      if (fuelTaxRoadType.getName().equalsIgnoreCase(name.trim())) {
        return fuelTaxRoadType;
      }
    }

    log.warn("{} is not recognized for {} enum; returning default {}",
        name, FuelTaxRoadType.class.getSimpleName(), FuelTaxRoadType.UNKNOWN);
    return UNKNOWN;
  }
}
