/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.fuel;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public enum FuelTransactionProvider implements HasName {

  /**
   * Unknown product type.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown", 0),

  /**
   * Wex Fuel Card Provider, legacy file format.
   */
  WEX_LEGACY("WexLegacy", 1),

  /**
   * Wex Fuel Card Provider, customer file format.
   */
  WEX_CUSTOMER("WexCustomer", 2),

  /**
   * Drive Add-in.
   */
  DRIVE("Drive", 3),

  /**
   * Fuel Tracker App.
   */
  FUEL_TRACKER("FuelTracker", 4),

  /**
   * Comdata Fuel Card Provider.
   */
  COMDATA("Comdata", 5),

  /**
   * Fuelman Fuel Card Provider.
   */
  FUELMAN("Fuelman", 6),

  /**
   * Wex Fuel Card Provider.
   */
  WEX("Wex", 7),

  /**
   * Voyager Fuel Card provider.
   */
  VOYAGER("Voyager", 8),

  /**
   * Ultramar CST Fuel Card provider.
   */
  ULTRAMAR_CST("UltramarCST", 9),

  /**
   * GFN Fuel Card provider.
   */
  GFN("GFN", 10),

  WEX_CANADA("WexCanada", 11),

  ALLSTAR("Allstar", 12),

  KEYFUELS("Keyfuels", 13),

  TFC("TFC", 14);

  private final String name;
  private final int code;

  FuelTransactionProvider(String name, int code) {
    this.name = name;
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  @JsonValue
  public String getName() {
    return name;
  }

  public static FuelTransactionProvider findOrDefault(String name) {
    if (Util.isEmpty(name)) {
      log.warn("Empty value is not recognized for {} enum; returning default {}",
          FuelTransactionProvider.class.getSimpleName(), FuelTransactionProvider.UNKNOWN);
      return UNKNOWN;
    }

    for (FuelTransactionProvider fuelTransactionProvider : values()) {
      if (fuelTransactionProvider.getName().equalsIgnoreCase(name.trim())) {
        return fuelTransactionProvider;
      }
    }

    log.warn("{} is not recognized for {} enum; returning default {}",
        name, FuelTransactionProvider.class.getSimpleName(), FuelTransactionProvider.UNKNOWN);
    return UNKNOWN;
  }
}
