package com.geotab.model.entity.fuel;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Getter;

public enum FuelUpEventConfidences {
  /**
   * None.
   */
  @JsonEnumDefaultValue
  NONE("None", 0),

  /**
   * Fuel level based "FuelUpEvent".
   */
  FUEL_LEVEL("FuelLevel", 1),

  /**
   * The "FuelUpEvent" that matched on trip stop date.
   */
  TRIP_STOP("TripStop", 2),

  /**
   * The "FuelTransaction"  based "FuelUpEvent".
   */
  FUEL_TRANSACTION("FuelTransaction", 4),

  /**
   * "FuelTransaction"  based "FuelUpEvent" that has a matched device.
   */
  DEVICE_MATCHED_FUEL_TRANSACTION("DeviceMatchedFuelTransaction", 8),

  /**
   * "FuelTransaction"  based "FuelUpEvent" that has matched trip stop by location.
   */
  LOCATION_MATCHED_FUEL_TRANSACTION("LocationMatchedFuelTransaction", 16),

  /**
   * "FuelTransaction"  based "FuelUpEvent" that has matched trip stop by date.
   */
  TRIP_STOP_FUEL_TRANSACTION("TripStopFuelTransaction", 32),

  /**
   * Fuel level based "FuelUpEvent" matched to "FuelTransaction" based "FuelUpEvent" by datetime and device.
   */
  DEVICE_FUEL_LEVEL_MATCHED_FUEL_TRANSACTION("DeviceFuelLevelMatchedFuelTransaction", 64),

  /**
   * Fuel level based "FuelUpEvent" matched to "FuelTransaction" based "FuelUpEvent" where locations match.
   */
  LOCATION_FUEL_LEVEL_MATCHED_FUEL_TRANSACTION("LocationFuelLevelMatchedFuelTransaction", 128),

  /**
   * The "Device" was not communicating at the time of transaction.
   */
  NOT_COMMUNICATING("NotCommunicating", 256),

  /**
   * Fuel level based "FuelUpEvent" could not be determined as there is not enough data.
   */
  FUEL_LEVEL_INDETERMINATE("FuelLevelIndeterminate", 512),

  /**
   * "FuelTransaction"  based "FuelUpEvent" that has a matched driver.
   */
  DRIVER_MATCHED_FUEL_TRANSACTION("DriverMatchedFuelTransaction", 1024),

  /**
   * Fuel used inconsistent.
   */
  FUEL_USED_INCONSISTENT("FuelUsedInconsistent", 2048),

  /**
   * The "Device" is reporting electric energy usage.
   */
  ENGINE_ELECTRIC_ENERGY("EngineElectricEnergy", 4096);

  private final String name;
  @Getter private final int code;

  FuelUpEventConfidences(String name, int code) {
    this.name = name;
    this.code = code;
  }

  @JsonValue
  public String getName() {
    return name;
  }
}
