/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.fuel;

import com.geotab.model.entity.EntityWithVersion;
import com.geotab.model.entity.device.Device;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * An event representing fuel used for a vehicle.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "fuelUsedBuilder")
public class FuelUsed extends EntityWithVersion {

  /**
   * The {@link Device} that this fuel event is associated with.
   */
  private Device device;

  /**
   * Gets or sets the volume of fuel used in Liters. Default {@code 0}.
   */
  private Double totalFuelUsed;

  /**
   * Gets or sets the UTC date and time of the fuel used.
   */
  private LocalDateTime dateTime;

  /**
   * The {@link FuelUpEventConfidences} of this transaction. Default [{@link FuelUpEventConfidences#NONE}].
   */
  private FuelUpEventConfidences confidence;

}
