package com.geotab.model.entity.group;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Represents a Defect entity. This defines the one to one relationship between a {@link DefectSeverity} and {@link
 * Group}
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "defectBuilder")
public class Defect extends Group {

  /**
   * The {@link DefectSeverity} of the Defect.
   */
  private DefectSeverity severity;

  /**
   * List of {@link Defect} groups.
   */
  private List<Group> groups;

  @JsonProperty("isDefectList")
  private Boolean isDefectList;
}
