package com.geotab.model.entity.group;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.entity.device.Device;
import com.geotab.model.serialization.HasName;

public enum DefectAssetType implements HasName {

  /**
   * Fallback when enumeration value is unknown.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown", -1),

  /**
   * Defect list that applies to any asset.
   */
  ALL("All", 0),

  /**
   * Defect list for a {@link Device}.
   */
  DEVICE("Device", 1),

  /**
   * Defect list for a Trailer.
   */
  TRAILER("Trailer", 2);

  private final String name;
  private final int code;

  DefectAssetType(String name, int code) {
    this.name = name;
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  @JsonValue
  public String getName() {
    return name;
  }
}
