package com.geotab.model.entity.group;

import com.geotab.model.Id;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * This is a {@link SystemSecurityClearance} with an Id of GroupNothingSecurityId. A user that has this group in its
 * security groups means that there is no access to anything in the system. This is useful if you want to revoke access
 * to the system or build upon this role and give access to a small set of items.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "nothingSecurityGroupBuilder")
public class NothingSecurityGroup extends SystemSecurityClearance {

  public static final String NOTHING_SECURITY_GROUP_ID = "GroupNothingSecurityId";
  public static final String NOTHING_SECURITY_GROUP_NAME = "**NothingSecurity**";

  {
    setId(new Id(NOTHING_SECURITY_GROUP_ID));
    setName(NOTHING_SECURITY_GROUP_NAME);
  }
}
