package com.geotab.model.entity.group;

import com.geotab.model.Id;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * This is a {@link Group} with an Id of GroupPrivateUserId. It contains private groups for all users. Each user ideally
 * would one group under this group. This way, it will be easy to schedule a report or a dashboard for a user.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "privateUserGroupBuilder")
public class PrivateUserGroup extends SystemGroupBase {

  public static final String PRIVATE_USER_GROUP_ID = "GroupPrivateUserId";
  public static final String PRIVATE_USER_GROUP_NAME = "**PrivateUser**";

  {
    setId(new Id(PRIVATE_USER_GROUP_ID));
    setName(PRIVATE_USER_GROUP_NAME);
  }
}
