package com.geotab.model.entity.group;

import com.geotab.model.SecurityFilter;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Represents a {@link Group} with {@link SecurityFilter}  that are used to determine security access to different parts
 * of the application.
 *
 * <p>To get all SecurityClearance(s), call the Get method with typeName {@link Group} and a
 * GroupSearch with the Id property set to GroupSecurityId
 */
@Data
@NoArgsConstructor
@SuperBuilder
public abstract class SecurityClearance extends Group {

  /**
   * The {@link SecurityFilter}(s) either adds or removes a particular SecurityIdentifier to a user's set of allowed
   * items.
   */
  private List<SecurityFilter> securityFilters;
}
