package com.geotab.model.entity.group;

import com.geotab.model.Id;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * This is a {@link SystemSecurityClearance}. The sub tree of this group is used to manage security to various parts of
 * the system.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "securityGroupBuilder")
public class SecurityGroup extends SystemSecurityClearance {

  public static final String SECURITY_GROUP_ID = "GroupSecurityId";
  public static final String SECURITY_GROUP_NAME = "**Security**";

  {
    setId(new Id(SECURITY_GROUP_ID));
    setName(SECURITY_GROUP_NAME);
  }
}
