package com.geotab.model.entity.group;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public enum SecurityIdentifier implements HasName {

  /**
   * The Unknown identifier is not used for security purposes. It's used internally to indicate a particular type could
   * not be translated into a security identifier. This always yields in access denied.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown"),

  EVERYTHING("Everything"),

  SYSTEM_SETTINGS("SystemSettings"),

  IMPORT_FROM_OTHER_DATABASE("ImportFromOtherDatabase"),

  AUDIT_LOG("AuditLog"),

  USER_LIST("UserList"),

  USER_ADMIN("UserAdmin"),

  PURGE_DATA("PurgeData"),

  DEVICE_LIST("DeviceList"),

  ENGINE_MANAGEMENT_REPORT("EngineManagementReport"),

  ZONE_TYPE_LIST("ZoneTypeList"),

  REPROCESS_DATA("ReprocessData"),

  WORK_TIME_LIST("WorkTimeList"),

  WORK_HOLIDAY_LIST("WorkHolidayList"),

  ZONE_LIST("ZoneList"),

  ZONE_ADMIN("ZoneAdmin"),

  EXCEPTIONS_LIST("ExceptionsList"),

  REMINDER_REPORT("ReminderReport"),

  EVENT_OCCURRENCE_LIST("EventOccurrenceList"),

  NODES_LIST("NodesList"),

  REMINDER_RULE_LIST("ReminderRuleList"),

  CHANGE_PASSWORD("ChangePassword"),

  CREATE_EXTRACT_KEY("CreateExtractKey"),

  CREATE_TEST_KEY("CreateTestKey"),

  CREATE_FIRMWARE_KEY("CreateFirmwareKey"),

  CREATE_PROGRAMMING_KEY("CreateProgrammingKey"),

  CREATE_KEY_BACKUP("CreateKeyBackup"),

  RESTORE_KEY_BACKUP("RestoreKeyBackup"),

  CREATE_WIFI_KEY("CreateWifiKey"),

  IMPORT_ZONES("ImportZones"),

  RADIO_DOWNLOADER_LIST("RadioDownloaderList"),

  NOTIFICATION_LIST("NotificationList"),

  ORGANIZE_VIEWS("OrganizeViews"),

  ROUTE_LIST("RouteList"),

  USER_SETTINGS("UserSettings"),

  ENGINE_DIAGNOSTIC_LIST("EngineDiagnosticList"),

  ENGINE_TYPE_LIST("EngineTypeList"),

  ENGINE_FAILURE_MODE_LIST("EngineFailureModeList"),

  ENGINE_FLASH_CODE_LIST("EngineFlashCodelist"),

  ENGINE_UNIT_OF_MEASURE_LIST("EngineUnitOfMeasureList"),

  TRIPS_ACTIVITY_REPORT("TripsActivityReport"),

  CONGREGATION_REPORT("CongregationReport"),

  CUSTOMER_VISITS_REPORT("CustomerVisitsReport"),

  SPEED_PROFILE_REPORT("SpeedProfileReport"),

  TIME_CARD_REPORT("TimeCardReport"),

  ENGINE_STATUS_DATA_GRAPH("EngineStatusDataGraph"),

  EXCEPTIONS_REPORT("ExceptionsReport"),

  RISK_MANAGEMENT_REPORT("RiskManagementReport"),

  ROUTE_SUMMARY_REPORT("RouteSummaryReport"),

  UNASSIGNED_ROUTE_REPORT("UnassignedRouteReport"),

  DRIVER_HISTORY_REPORT("DriverHistoryReport"),

  ACCIDENT_DEBUG_REPORT("AccidentDebugReport"),

  DEVICE_INSTALL_HISTORY_REPORT("DeviceInstallHistoryReport"),

  PERFORMANCE_REPORT("PerformanceReport"),

  LAUNCH_ADD_IN("LaunchAddIn"),

  DEVICE_ADMIN("DeviceAdmin"),

  DEVICE_ADMIN_DELETE_UNPLUG_REPLACE("DeviceAdminDeleteUnplugReplace"),

  KEY_INFORMATION("KeyInformation"),

  SECURITY_CLEARANCE_LIST("SecurityClearanceList"),

  TRACK_HISTORIC_DATA("TrackHistoricData"),

  SERVICES_SETTINGS("ServicesSettings"),

  MILEAGE_SUMMARY_DASHBOARD("MileageSummaryDashboard"),

  ACCIDENT_WIZARD("AccidentWizard"),

  FUEL_TAX("FuelTax"),

  MANAGE_REPORT_TEMPLATES("ManageReportTemplates"),

  VIEW_REPORT_TEMPLATE("ViewReportTemplate"),

  EXPORT_FROM_OTHER_DATABASE("ExportFromOtherDatabase"),

  VIEW_GPS_TEXT_MESSAGE("ViewGpsTextMessage"),

  SEND_GPS_TEXT_MESSAGE("SendGpsTextMessage"),

  DELETE_GPS_TEXT_MESSAGE("DeleteGpsTextMessage"),

  REQUEST_DEVICE_LOCATION("RequestDeviceLocation"),

  DISPLAY_MAP("DisplayMap"),

  START_FULL_VERSION("StartFullVersion"),

  EDIT_NOTIFICATION_EMAIL_TEMPLATE("EditNotificationEmailTemplate"),

  DEVICE_ADMIN_ADVANCED("DeviceAdminAdvanced"),

  DEVICE_ADMIN_DRIVER_FEEDBACK("DeviceAdminDriverFeedback"),

  EDIT_DEVICE_ODOMETER("EditDeviceOdometer"),

  SEND_EXTERNAL_RELAY_INSTRUCTION("SendExternalRelayInstruction"),

  ABOUT_CHECKMATE("AboutCheckmate"),

  FUEL_USAGE_REPORT("FuelUsageReport"),

  DRIVER_BLACKLIST("DriverBlacklist"),

  EDIT_EXCEPTION("EditException"),

  EDIT_DISTRIBUTION_LIST("EditDistributionList"),

  ROUTE_COMPARISON_REPORT("RouteComparisonReport"),

  MANAGE_HOS_LOGS("ManageHOSLogs"),

  VIEW_HOS_LOGS("ViewHOSLogs"),

  VIEW_DVIR_LOGS("ViewDVIRLogs"),

  MANAGE_DVIR_LOGS("ManageDVIRLogs"),

  VIEW_TRAILERS("ViewTrailers"),

  MANAGE_TRAILERS("ManageTrailers"),

  VIEW_ADVANCED_HELP("ViewAdvancedHelp"),

  EDIT_ROAD_SPEEDS("EditRoadSpeeds"),

  FUEL_TRANSACTION_LIST("FuelTransactionList"),

  FUEL_TRANSACTION_ADMIN("FuelTransactionAdmin"),

  VIEW_MARKETPLACE_PAID_ITEMS("ViewMarketplacePaidItems"),

  VIEW_CERTIFICATES("ViewCertificates"),

  MANAGE_CERTIFICATES("ManageCertificates"),

  REPAIR_DVIR("RepairDVIR"),

  PURCHASE_MARKETPLACE_PAID_ITEMS("PurchaseMarketplacePaidItems"),

  MANAGE_ADD_IN_DATA("ManageAddInData"),

  VIEW_ADD_IN_DATA("ViewAddInData"),

  VIEW_BINARY_DATA("ViewBinaryData"),

  DRIVER_IDENTIFICATION_CLEARANCE("DriverIdentificationClearance"),

  ACCELEROMETER_DATA_CLEARANCE("AccelerometerDataClearance"),

  SERVICE_PLANS_CLEARANCE("ServicePlansClearance"),

  AUXILIARY_CLEARANCE("AuxiliaryClearance"),

  ENGINE_STATUS_DATA_CLEARANCE("EngineStatusDataClearance"),

  RESELLER_CONTROL_CLEARANCE("ResellerControlClearance"),

  GO_TALK_CLEARANCE("GoTalkClearance"),

  STATUS_GROUPS_CLEARANCE("StatusGroupsClearance"),

  PRODUCT_GUIDE_CLEARANCE("ProductGuideClearance"),

  FEATURE_PREVIEW_CLEARANCE("FeaturePreviewClearance"),

  NEWS_NOTIFICATIONS_CLEARANCE("NewsNotificationsClearance"),

  MANAGE_ADDINS_CLEARANCE("ManageAddinsClearance"),

  DEVICE_CURRENT_STATUS_CLEARANCE("DeviceCurrentStatusClearance"),

  VIEW_TRIP_TYPE_CHANGE_DATA("ViewTripTypeChangeData"),

  EDIT_TRIP_TYPE_CHANGE_DATA("EditTripTypeChangeData"),

  DIRECT_SUPPORT_ADMIN("DirectSupportAdmin"),

  VIEW_BUSINESS_INTELLIGENCE("ViewBusinessIntelligence"),

  ACTIVE_TRACKING_CLEARANCE("ActiveTrackingClearance"),

  CERTIFY_DVIR("CertifyDVIR"),

  INSPECT_DVIR("InspectDVIR"),

  VIEW_MEDIA("ViewMedia"),

  MANAGE_MEDIA("ManageMedia"),

  VIEW_GROUPS("ViewGroups"),

  ADMINISTER_WIFI_HOTSPOT_SETTINGS("AdministerWiFiHotspotSettings"),

  TACHOGRAPH_DOWNLOAD_AND_UPLOAD_FILES("TachographDownloadAndUploadFiles"),

  TACHOGRAPH_ADMIN("TachographAdmin"),

  VIEW_TACHOGRAPH_REMOTE_DOWNLOAD_DATA("ViewTachographRemoteDownloadData"),

  VIEW_TACHOGRAPH_DRIVING_TIME_DATA("ViewTachographDrivingTimeData"),

  VIEW_TACHOGRAPH_INFRINGEMENT_DATA("ViewTachographInfringementData"),

  VIEW_WIFI_HOTSPOT_SETTINGS("ViewWiFiHotspotSettings"),

  MATERIAL_MANAGEMENT_REPORT("MaterialManagementReport"),

  VIEW_DEVICE_SHARE("ViewDeviceShare"),

  EDIT_DEVICE_SHARE("EditDeviceShare"),

  VIEW_TRIP_CATEGORY_CHANGE("ViewTripCategoryChange"),

  EDIT_TRIP_CATEGORY_CHANGE("EditTripCategoryChange"),

  VIEW_USER_DEVICE_LINK("ViewUserDeviceLink"),

  EDIT_USER_DEVICE_LINK("EditUserDeviceLink"),

  INSTALL_RECORD("InstallRecord"),

  ROUTE_COMPLETION_REPORT("RouteCompletionReport"),

  VIEW_ACTIVE_INSIGHTS("ViewActiveInsights"),

  VIEW_ANALYTICS_LAB("ViewAnalyticsLab"),

  VIEW_SHAREABLE_LINK("ViewShareableLink"),

  CREATE_SHAREABLE_LINK("CreateShareableLink"),

  DELETE_SHAREABLE_LINK("DeleteShareableLink"),

  VIEW_DEVICE_DATA_PRIVACY_CHANGE_DATA("ViewDeviceDataPrivacyChangeData"),

  EDIT_DEVICE_DATA_PRIVACY_CHANGE_DATA("EditDeviceDataPrivacyChangeData"),

  IGNORE_HOS_LOGS("IgnoreHOSLogs"),

  ADMINISTER_PROPERTY_SET("AdministerPropertySet"),

  VIEW_PROPERTY_SET("ViewPropertySet"),

  ADMINISTER_PROPERTY("AdministerProperty"),

  VIEW_PROPERTY("ViewProperty"),

  VIEW_SHARED_DEVICE("ViewSharedDevice"),

  MANAGE_DRIVER_ACTIVITY_GROUP("ManageDriverActivityGroup"),

  VIEW_TRIP_ANNOTATION("ViewTripAnnotation"),

  MANAGE_TRIP_ANNOTATION("ManageTripAnnotation"),

  EXCEPTION_EVENT_REVIEW_PARTICIPANT("ExceptionEventReviewParticipant"),

  EXCEPTION_EVENT_REVIEWER("ExceptionEventReviewer"),

  ADMINISTER_LIVE_MAP("AdministerLiveMap"),

  EV_BATTERY_HEALTH_REPORT("EVBatteryHealthReport"),

  MANAGE_BINARY_DATA_FILES("ManageBinaryDataFiles"),

  MODIFY_GROUP_FILTER("ModifyGroupFilter"),

  VIEW_BINARY_DATA_FILES("ViewBinaryDataFiles"),

  VIEW_GROUP_FILTER("ViewGroupFilter"),

  VIEW_LIVE_MAP("ViewLiveMap");

  private final String name;

  SecurityIdentifier(String name) {
    this.name = name;
  }

  @JsonValue
  public String getName() {
    return name;
  }

  public static SecurityIdentifier findOrDefault(String name) {
    if (Util.isEmpty(name)) {
      log.warn("Empty value is not recognized for {} enum; returning default {}",
          SecurityIdentifier.class.getSimpleName(), SecurityIdentifier.UNKNOWN);
      return UNKNOWN;
    }

    for (SecurityIdentifier securityIdentifier : values()) {
      if (securityIdentifier.getName().equalsIgnoreCase(name.trim())) {
        return securityIdentifier;
      }
    }

    log.warn("{} is not recognized for {} enum; returning default {}",
        name, SecurityIdentifier.class.getSimpleName(), SecurityIdentifier.UNKNOWN);
    return UNKNOWN;
  }
}
