package com.geotab.model.entity.group;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonProperty.Access;
import com.geotab.model.drawing.Color;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * The base class for all groups that are a system group.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "systemGroupBaseBuilder")
public class SystemGroupBase extends Group {

  @JsonProperty(access = Access.WRITE_ONLY)
  public String getName() {
    return super.getName();
  }

  @Override
  public Color getColor() {
    return Color.EMPTY;
  }

  @Override
  public boolean isSystemEntity() {
    return true;
  }
}
