package com.geotab.model.entity.group;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonProperty.Access;
import com.geotab.model.drawing.Color;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * The base class for {@link SecurityClearance}(s) that are system entities.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public abstract class SystemSecurityClearance extends SecurityClearance {

  @JsonProperty(access = Access.WRITE_ONLY)
  public String getName() {
    return super.getName();
  }

  @Override
  public Color getColor() {
    return Color.EMPTY;
  }

  @Override
  public boolean isSystemEntity() {
    return true;
  }
}
