package com.geotab.model.entity.group;

import com.geotab.model.Id;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * This is a {@link SystemSecurityClearance} with an Id of GroupUserSecurityId. A user that has this group assigned to
 * its security groups will have the default level of access.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "userSecurityGroupBuilder")
public class UserSecurityGroup extends SystemSecurityClearance {

  public static final String USER_SECURITY_GROUP_ID = "GroupUserSecurityId";
  public static final String USER_SECURITY_GROUP_NAME = "**UserSecurity**";

  {
    setId(new Id(USER_SECURITY_GROUP_ID));
    setName(USER_SECURITY_GROUP_NAME);
  }
}
