/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.ioxaddon;

import lombok.experimental.UtilityClass;

/**
 * A unique identifier for different types {@link IoxAddOn}s. The range of valid values is between 4096 (inclusive) and
 * 8192.
 */
@UtilityClass
public final class KnownIoxAddOnType {

  /**
   * The Garmin Iox Add-On type. Integer value is 4096.
   */
  public static final int GARMIN = 4096;

  /**
   * The GoTalk Iox Add-On type. Integer value is 4125.
   */
  public static final int GO_TALK = 4125;

  /**
   * The Output Iox Add-On type. Integer value is 4135.
   */
  public static final int IOX_OUTPUT = 4135;

  /**
   * The Iridium Iox Add-On type. Integer value is 4097.
   */
  public static final int IRIDIUM = 4097;
}
