/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.notification;

import com.geotab.model.Id;
import lombok.Data;

/**
 * The default application exception email template.
 */
@Data
public final class DefaultApplicationExceptionEmailTemplate extends SystemEmailTemplate {

  private static class InstanceHolder {

    private static final DefaultApplicationExceptionEmailTemplate INSTANCE =
        new DefaultApplicationExceptionEmailTemplate();
  }

  public static final String EMAIL_TEMPLATE_DEFAULT_APPLICATION_EXCEPTION_ID =
      "EmailTemplateDefaultApplicationExceptionId";

  private DefaultApplicationExceptionEmailTemplate() {
    setId(new Id(EMAIL_TEMPLATE_DEFAULT_APPLICATION_EXCEPTION_ID));
    setName("DefaultApplicationExceptionEmailTemplate");
    setSubject("Notification on {database}");
    setBody("Notification at {time} {date} from {source}: {info}");
  }

  public static DefaultApplicationExceptionEmailTemplate getInstance() {
    return DefaultApplicationExceptionEmailTemplate.InstanceHolder.INSTANCE;
  }
}
