/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.notification;

import com.geotab.model.Id;
import lombok.Data;

/**
 * The default rule exception email template.
 */
@Data
public final class DefaultExceptionRuleEmailTemplate extends SystemEmailTemplate {

  private static class InstanceHolder {

    private static final DefaultExceptionRuleEmailTemplate INSTANCE = new DefaultExceptionRuleEmailTemplate();
  }

  public static final String EMAIL_TEMPLATE_DEFAULT_EXCEPTION_RULE_ID = "EmailTemplateDefaultExceptionRuleId";

  private DefaultExceptionRuleEmailTemplate() {
    setId(new Id(EMAIL_TEMPLATE_DEFAULT_EXCEPTION_RULE_ID));
    setName("DefaultExceptionRuleEmailTemplate");
    setSubject("Notification for {database}");
    setBody("{deviceWithDriverName} broke \"{rule}\" rule at {time} {date}.");
  }

  public static DefaultExceptionRuleEmailTemplate getInstance() {
    return DefaultExceptionRuleEmailTemplate.InstanceHolder.INSTANCE;
  }
}
