/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.notification;

import com.geotab.model.Id;
import lombok.Data;

/**
 * The default maintenance notificaiton email template.
 */
@Data
public final class DefaultMaintenanceReminderEmailTemplate extends SystemEmailTemplate {

  private static class InstanceHolder {

    private static final DefaultMaintenanceReminderEmailTemplate INSTANCE =
        new DefaultMaintenanceReminderEmailTemplate();
  }

  public static final String EMAIL_TEMPLATE_DEFAULT_MAINTENANCE_REMINDER_ID =
      "EmailTemplateDefaultMaintenanceReminderId";

  private DefaultMaintenanceReminderEmailTemplate() {
    setId(new Id(EMAIL_TEMPLATE_DEFAULT_MAINTENANCE_REMINDER_ID));
    setName("DefaultMaintenanceReminderEmailTemplate");
    setSubject("{maintenanceReminderType} - {maintenanceReminderName}");
    setBody("MaintenanceNotificationTemplateBody");
  }

  public static DefaultMaintenanceReminderEmailTemplate getInstance() {
    return DefaultMaintenanceReminderEmailTemplate.InstanceHolder.INSTANCE;
  }
}
