/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.notification;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.geotab.model.entity.reporttemplate.ReportTemplate;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Stores custom email notifications.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "emailTemplateBuilder")
@JsonIgnoreProperties({"exceptionsDetailTemplateSqlId"})
public class EmailTemplate extends NotificationBinaryFile {

  /**
   * The email body.
   */
  private String body;

  /**
   * Report template.
   */
  private ReportTemplate exceptionsDetailTemplate;

  /**
   * Subject line of email.
   */
  private String subject;

  {
    setFileType(MediaFileType.NOTIFICATION_EMAIL_TEMPLATE);
    setType(NotificationBinaryFileType.EMAIL_TEMPLATE);
  }
}
