/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.notification;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public enum NotificationBinaryFileType implements HasName {


  /**
   * Notification binary file type. None.
   */
  @JsonEnumDefaultValue
  NONE("None"),

  /**
   * The Audio Alarm Binary file type.
   */
  AUDIO_ALARM_FILE(NotificationBinaryFile.AUDIO_ALARM_FILE),

  /**
   * The email template binary file type.
   */
  EMAIL_TEMPLATE(NotificationBinaryFile.EMAIL_TEMPLATE),

  /**
   * The Web request template binary file type.
   */
  WEB_REQUEST_TEMPLATE(NotificationBinaryFile.WEB_REQUEST_TEMPLATE),

  /**
   * The text message template.
   */
  TEXT_TEMPLATE(NotificationBinaryFile.TEXT_TEMPLATE);


  private final String name;

  NotificationBinaryFileType(String name) {
    this.name = name;
  }

  @JsonValue
  public String getName() {
    return name;
  }

  public static NotificationBinaryFileType findOrDefault(String name) {
    if (Util.isEmpty(name)) {
      log.warn("Empty value is not recognized for {} enum; returning default {}",
          NotificationBinaryFileType.class.getSimpleName(), NotificationBinaryFileType.NONE);
      return NONE;
    }

    for (NotificationBinaryFileType notificationBinaryFileType : values()) {
      if (notificationBinaryFileType.getName().equalsIgnoreCase(name.trim())) {
        return notificationBinaryFileType;
      }
    }

    log.warn("{} is not recognized for {} enum; returning default {}",
        name, NotificationBinaryFileType.class.getSimpleName(), NotificationBinaryFileType.NONE);
    return NONE;
  }
}
