/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.notification;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public enum NotificationTemplatePurpose implements HasName {

  /**
   * Fallback when enumeration value is unknown.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown", -1),

  /**
   * User template for exceptionEvents.
   */
  EXCEPTION_EVENT("ExceptionEvent", 0),

  /**
   * User template for maintenance notification reminders.
   */
  MAINTENANCE_NOTIFICATION("MaintenanceNotification", 1);

  private final String name;
  private final int code;

  NotificationTemplatePurpose(String name, int code) {
    this.name = name;
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  @JsonValue
  public String getName() {
    return name;
  }

  public static NotificationTemplatePurpose findOrDefault(String name) {
    if (Util.isEmpty(name)) {
      log.warn("Empty value is not recognized for {} enum; returning default {}",
          NotificationTemplatePurpose.class.getSimpleName(),
          NotificationTemplatePurpose.MAINTENANCE_NOTIFICATION);
      return MAINTENANCE_NOTIFICATION;
    }

    for (NotificationTemplatePurpose fuelTaxRoadType : values()) {
      if (fuelTaxRoadType.getName().equalsIgnoreCase(name.trim())) {
        return fuelTaxRoadType;
      }
    }

    log.warn("{} is not recognized for {} enum; returning default {}",
        name, NotificationTemplatePurpose.class.getSimpleName(),
        NotificationTemplatePurpose.MAINTENANCE_NOTIFICATION);
    return MAINTENANCE_NOTIFICATION;
  }
}
