/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.notification;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * URL template.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "webRequestTemplateBuilder")
public class WebRequestTemplate extends NotificationBinaryFile {

  /**
   * The body.
   */
  private String postBody;

  /**
   * The request type is an HTTP GET or POST.
   */
  private WebRequestTemplateHttpVerb requestType;

  /**
   * The url represented by a string.
   */
  private String url;

  {
    setFileType(MediaFileType.WEB_REQUEST_TEMPLATE);
    setType(NotificationBinaryFileType.WEB_REQUEST_TEMPLATE);
  }
}
