/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.reporttemplate;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.entity.NameEntity;
import com.geotab.model.serialization.ByteArrayDeserializer;
import com.geotab.model.serialization.ByteArraySerializer;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * ReportTemplate class represents a template for reports that is an Excel file.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class ReportTemplate extends NameEntity {

  /**
   * The Excel binary data.
   */
  @JsonDeserialize(using = ByteArrayDeserializer.class)
  @JsonSerialize(using = ByteArraySerializer.class)
  private Byte[] binaryData;

  /**
   * Whether the ReportTemplate is System.
   */
  @JsonProperty("isSystem")
  private Boolean isSystem;

  /**
   * The {@link ReportDataSource}.
   */
  private ReportDataSource reportDataSource;

  /**
   * The {@link ReportTemplateType}.
   */
  private ReportTemplateType reportTemplateType;

  /**
   * Whether the ReportTemplate is shown in the report dropdowns.
   */
  @JsonProperty("showReport")
  private Boolean showReport;
}
