/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.route;

import com.geotab.model.entity.NameEntityWithVersion;
import com.geotab.model.entity.device.Device;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * A connected sequence of zones which create a path for the vehicle to follow.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class Route extends NameEntityWithVersion {

  /**
   * Free text field where any user information can be stored and referenced for this entity. Default [""].
   */
  private String comment;

  /**
   * The {@link RoutePlanItem} item collection (sequence of stops which make up the route).
   */
  private List<RoutePlanItem> routePlanItemCollection;

  /**
   * The {@link RouteType}. Default [{@link RouteType#BASIC}].
   */
  private RouteType routeType;

  /**
   * The {@link Device} linked to the route. Only applies to "Plan" type routes.
   */
  private Device device;
}
