/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.rule;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.entity.zone.Zone;
import com.geotab.model.serialization.HasName;

public enum ExceptionRuleBaseType implements HasName {

  /**
   * Unknown base type.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown", -1),

  /**
   * Custom Exception rule. All user created rules are custom rules.
   */
  CUSTOM("Custom", 0),

  /**
   * Route Definition base rule.
   */
  ROUTE_DEFINITION("RouteDefinition", 23),

  /**
   * Stock (canned) exception rule. These are the common rules available to switch on/off in MyGeotab.
   */
  STOCK("Stock", 25),

  /**
   * Zone stop rule. When a {@link Zone}'s MustIdentifyStops property is set to true, the system creates a rule to
   * identify when a device is stopped in the zone. These rules are of type ZoneStop.
   */
  ZONE_STOP("ZoneStop", 26),

  /**
   * Route completion rule.
   */
  ROUTE_COMPLETION("RouteCompletion", 27),

  /**
   * Material management rule.
   */
  ROUTE_BASED_MATERIAL_MGMT("RouteBasedMaterialMgmt", 28),

  /**
   * Virtual rule.
   */
  VIRTUAL("Virtual", 29);

  private final String name;
  private final int code;

  ExceptionRuleBaseType(String name, int code) {
    this.name = name;
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  @JsonValue
  public String getName() {
    return name;
  }
}
