/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.security;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.geotab.model.entity.NameEntityWithVersion;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * For managing security identifiers.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class SecurityId extends NameEntityWithVersion {

  /**
   * The custom page name.
   */
  private String customPageName;

  /**
   * Indicates whether this securityIdentifier is a system Id or custom identifier.
   */
  @JsonProperty("isSystemSecurityId")
  private Boolean isSystemSecurityId;
}
