/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import lombok.Data;

/**
 * Specifies that the engine data originated from proprietary sources.
 */
@Data
public final class SourceBrp extends Source {

  private static class InstanceHolder {

    private static final SourceBrp INSTANCE = new SourceBrp();
  }

  public static final String SOURCE_BRP_ID = "SourceBrpId";

  private SourceBrp() {
    super(SOURCE_BRP_ID, "**Brp");
  }

  public static SourceBrp getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
