/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import lombok.Data;

/**
 * Specifies that the engine data originated from Brp sources for an obsolete GUID.
 */
@Data
public final class SourceBrpObsolete extends Source {

  private static class InstanceHolder {

    private static final SourceBrpObsolete INSTANCE = new SourceBrpObsolete();
  }

  public static final String SOURCE_BRP_OBSOLETE_ID = "SourceBrpObsoleteId";

  private SourceBrpObsolete() {
    super(SOURCE_BRP_OBSOLETE_ID, "**Brp Obsolete");
  }

  public static SourceBrpObsolete getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
