/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import lombok.Data;

/**
 * Specifies that the engine data originated from proprietary sources.
 */
@Data
public final class SourceGmccc extends Source {

  private static class InstanceHolder {

    private static final SourceGmccc INSTANCE = new SourceGmccc();
  }

  public static final String SOURCE_GMCCC_ID = "SourceGmcccId";

  private SourceGmccc() {
    super(SOURCE_GMCCC_ID, "**Gmccc");
  }

  public static SourceGmccc getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
