/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import lombok.Data;

/**
 * Specifies that the engine data originated from proprietary sources.
 */
@Data
public final class SourceGmcccObsolete extends Source {

  private static class InstanceHolder {

    private static final SourceGmcccObsolete INSTANCE = new SourceGmcccObsolete();
  }

  public static final String SOURCE_GMCCC_OBSOLETE_ID = "SourceGmcccObsoleteId";

  private SourceGmcccObsolete() {
    super(SOURCE_GMCCC_OBSOLETE_ID, "**Gmccc Obsolete");
  }

  public static SourceGmcccObsolete getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
