/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import lombok.Data;

/**
 * Specifies that the engine data originated from a Go device.
 */
@Data
public final class SourceGo extends Source {

  private static class InstanceHolder {

    private static final SourceGo INSTANCE = new SourceGo();
  }

  public static final String SOURCE_GEOTAB_GO_ID = "SourceGeotabGoId";

  private SourceGo() {
    super(SOURCE_GEOTAB_GO_ID, "**Go");
  }

  public static SourceGo getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
