/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import lombok.Data;

/**
 * Specifies that the engine data originated from a J1708 engine computer for an obsolete GUID.
 */
@Data
public final class SourceJ1708Obsolete extends Source {

  private static class InstanceHolder {

    private static final SourceJ1708Obsolete INSTANCE = new SourceJ1708Obsolete();
  }

  public static final String SOURCE_J1708_OBSOLETE_ID = "SourceJ1708ObsoleteId";

  private SourceJ1708Obsolete() {
    super(SOURCE_J1708_OBSOLETE_ID, "**J1708 Obsolete");
  }

  public static SourceJ1708Obsolete getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
