/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import lombok.Data;

/**
 * Specifies that the engine data originated from a legacy proprietary source.
 */
@Data
public final class SourceLegacy extends Source {

  private static class InstanceHolder {

    private static final SourceLegacy INSTANCE = new SourceLegacy();
  }

  public static final String SOURCE_LEGACY_ID = "SourceLegacyId";

  private SourceLegacy() {
    super(SOURCE_LEGACY_ID, "**Legacy");
  }

  public static SourceLegacy getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
