/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import lombok.Data;

/**
 * Specifies that the engine data originated from a Levc proprietary source for an obsolete GUID.
 */
@Data
public class SourceLevcObsolete extends Source {

  private static class InstanceHolder {

    private static final SourceLevcObsolete INSTANCE = new SourceLevcObsolete();
  }

  public static final String SOURCE_LECV_OBSOLETE_ID = "SourceLevcObsoleteId";

  private SourceLevcObsolete() {
    super(SOURCE_LECV_OBSOLETE_ID, "**Levc Obsolete");
  }

  public static SourceLevcObsolete getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
