/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import lombok.Data;

/**
 * Specifies that the engine data originated from an OBD II engine computer.
 */
@Data
public final class SourceObd extends Source {

  private static class InstanceHolder {

    private static final SourceObd INSTANCE = new SourceObd();
  }

  public static final String SOURCE_OBD_ID = "SourceObdId";

  private SourceObd() {
    super(SOURCE_OBD_ID, "**OBD");
  }

  public static SourceObd getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
